FILESEXTRAPATHS_prepend := "${THISDIR}/${PN}:"
S = "${WORKDIR}/git"
SRC_URI += "${RDK_CPC_ROOT_GIT}/apparmor-profiles/generic;protocol=${RDK_GIT_PROTOCOL};branch=${RDK_GIT_BRANCH};destsuffix=git/apparmor-profiles;name=apparmor-profiles"
SRCREV_apparmor-profiles = "${AUTOREV}"
SRCREV_FORMAT = "apparmor-profiles"

PACKAGE_BEFORE_PN += "${PN}-optimized"
#SYSTEMD_SERVICE_${PN} = "apparmor.service"

do_install_append () {
    install -d ${D}${sysconfdir}/apparmor/caps
    install -d ${D}${sysconfdir}/apparmor/cron
    if [ ! -d ${D}/etc/apparmor.d/ ]; then
           mkdir ${D}/etc/apparmor.d/
    fi
    if echo "${MACHINE_IMAGE_NAME}" | grep 'AX014AN'; then
       APPARMOR_MACHINE_PROFILE="AX014AN"
    fi
    if echo "${MACHINE_IMAGE_NAME}" | grep 'AX061AEI'; then
       APPARMOR_MACHINE_PROFILE="AX061AEI"
    fi
    if echo "${MACHINE_IMAGE_NAME}" | grep 'TX061AEI'; then
       APPARMOR_MACHINE_PROFILE="TX061AEI"
    fi
    if echo "${MACHINE_IMAGE_NAME}" | grep 'SKXI11'; then
       APPARMOR_MACHINE_PROFILE="SKXI11"
    fi
    if echo "${MACHINE_IMAGE_NAME}" | grep 'SCXI11AIC' || echo "${MACHINE_IMAGE_NAME}" | grep 'WNXI11AEI'; then
       APPARMOR_MACHINE_PROFILE="SCXWNX"
    fi
    if echo "${MACHINE_IMAGE_NAME}" | grep 'SCXI11BEI'; then
       APPARMOR_MACHINE_PROFILE="SCXI11BEI"
    fi
    #installing apparmor profiles
    for i in ${S}/apparmor-profiles/RDKV/*; do
        name=$(basename "$i")
        if [  -e "${S}/apparmor-profiles/profiles/video/${APPARMOR_MACHINE_PROFILE}/$name" ]; then
               sed -i 's/}//' ${S}/apparmor-profiles/RDKV/$name
               sed -i '1d' ${S}/apparmor-profiles/profiles/video/${APPARMOR_MACHINE_PROFILE}/$name
               cat ${S}/apparmor-profiles/RDKV/$name ${S}/apparmor-profiles/profiles/video/${APPARMOR_MACHINE_PROFILE}/$name > ${D}${sysconfdir}/apparmor.d/$name
        fi
    done

    install -m 0644 ${S}/apparmor-profiles/RDKV/global ${D}${sysconfdir}/apparmor.d/
    install -m 0644 ${S}/apparmor-profiles/default ${D}${sysconfdir}/apparmor/caps/
    install -m 0644 ${S}/apparmor-profiles/cron_default ${D}${sysconfdir}/apparmor/cron/
    install -m 0755 ${S}/apparmor-profiles/aar_telemetry_rdkv.sh   ${D}${sysconfdir}/apparmor/aar_telemetry.sh
    install -m 0755 ${S}/apparmor-profiles/apparmor_parse_rdkv.sh   ${D}${sysconfdir}/apparmor/apparmor_parse.sh
    install -m 0755 ${S}/apparmor-profiles/profiles/video/${APPARMOR_MACHINE_PROFILE}/apparmor_defaults ${D}${sysconfdir}/apparmor/apparmor_defaults
    install -m 0644 ${S}/apparmor-profiles/apparmor_rdkv.service ${D}${systemd_system_unitdir}/apparmor.service
}
FILES_${PN}-optimized = "${sysconfdir}/apparmor/parser.conf \
                         ${sysconfdir}/apparmor/subdomain.conf \
                         ${sysconfdir}/init.d/apparmor \
                         ${base_libdir}/apparmor/functions \
                         ${base_libdir}/apparmor/rc.apparmor.functions \
                         ${bindir}/aa-enabled \
                         ${bindir}/aa-exec"



